/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.capability;

import dev.onyxstudios.cca.api.v3.component.Component;
import dev.onyxstudios.cca.api.v3.component.ComponentKey;
import dev.onyxstudios.cca.api.v3.component.ComponentRegistry;
import dev.onyxstudios.cca.api.v3.entity.EntityComponentFactoryRegistry;
import dev.onyxstudios.cca.api.v3.entity.EntityComponentInitializer;
import java.util.Optional;
import me.pepperbell.simplenetworking.S2CPacket;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityWorldChangeEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.network.SyncPersistentDataPacket;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.library.tools.capability.EntityModifierCapability;
import slimeknights.tconstruct.library.tools.nbt.NamespacedNBT;

public class PersistentDataCapability
implements EntityComponentInitializer {
    private static final class_2960 ID = TConstruct.getResource("persistent_data");
    public static final ComponentKey<NamespacedNBT> CAPABILITY = ComponentRegistry.getOrCreate((class_2960)ID, NamespacedNBT.class);

    public static NamespacedNBT getOrWarn(class_1297 entity) {
        Optional data = CAPABILITY.maybeGet((Object)entity);
        if (data.isEmpty()) {
            TConstruct.LOG.warn("Missing Tinkers NBT on entity {}, this should not happen", (Object)entity.method_5864());
            return new NamespacedNBT();
        }
        return (NamespacedNBT)data.get();
    }

    public static void register() {
        ServerPlayerEvents.COPY_FROM.register(PersistentDataCapability::playerClone);
        ServerPlayerEvents.AFTER_RESPAWN.register(PersistentDataCapability::playerRespawn);
        ServerEntityWorldChangeEvents.AFTER_PLAYER_CHANGE_WORLD.register(PersistentDataCapability::playerChangeDimension);
        ServerPlayConnectionEvents.JOIN.register(PersistentDataCapability::playerLoggedIn);
    }

    public void registerEntityComponentFactories(EntityComponentFactoryRegistry registry) {
        for (Class<? extends class_1297> clazz : EntityModifierCapability.ENTITY_PREDICATES) {
            registry.registerFor(clazz, CAPABILITY, entity -> new NamespacedNBT());
        }
        registry.registerForPlayers(CAPABILITY, player -> new NamespacedNBT());
    }

    private static void sync(class_1657 player) {
        CAPABILITY.maybeGet((Object)player).ifPresent(data -> TinkerNetwork.getInstance().sendTo((S2CPacket)new SyncPersistentDataPacket(data.getCopy()), player));
    }

    private static void playerClone(class_3222 oldPlayer, class_3222 newPlayer, boolean alive) {
        CAPABILITY.maybeGet((Object)oldPlayer).ifPresent(oldData -> {
            class_2487 nbt = oldData.getCopy();
            if (!nbt.method_33133()) {
                CAPABILITY.maybeGet((Object)newPlayer).ifPresent(newData -> newData.copyFrom(nbt));
            }
        });
    }

    private static void playerRespawn(class_3222 oldPlayer, class_3222 newPlayer, boolean alive) {
        PersistentDataCapability.sync((class_1657)newPlayer);
    }

    private static void playerChangeDimension(class_3222 player, class_3218 origin, class_3218 destination) {
        PersistentDataCapability.sync((class_1657)player);
    }

    private static void playerLoggedIn(class_3244 handler, PacketSender sender, MinecraftServer server) {
        PersistentDataCapability.sync((class_1657)handler.method_32311());
    }

    private static class Provider
    implements Component {
        private NamespacedNBT capability = NamespacedNBT.readFromNBT(new class_2487());

        private Provider(class_1297 entity) {
        }

        public NamespacedNBT getCapability() {
            return this.capability;
        }

        public void writeToNbt(class_2487 tag) {
            this.capability.writeToNbt(tag);
        }

        public void readFromNbt(class_2487 nbt) {
            this.capability = NamespacedNBT.readFromNBT(nbt);
        }
    }
}

